#ifndef _TABCLIENTDBS_H
#define _TABCLIENTDBS_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"

#include "../Source/NSWFL.H"
#include "../Source/Entry.H"
#include "../Source/Init.H"
#include "../Source/WinService.H"
#include "../Source/Routines.H"
#include "../Source/SQLImport.H"

#include "../CSockSrvr/CSockSrvr.H"

#include "../Dialogs/MainDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK TabClientDBSDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    static HWND SQLServer_hWnd;
    static HWND SQLDriver_hWnd;
    static HWND SQLUserName_hWnd;
    static HWND SQLPassword_hWnd;
    static HWND TempDir_hWnd;

    if(xMessage == WM_INITDIALOG)
    {
        SQLServer_hWnd   = GetDlgItem(xHandle, IDC_SQLSERVER);
        SQLDriver_hWnd   = GetDlgItem(xHandle, IDC_SQLDRIVER);
        SQLUserName_hWnd = GetDlgItem(xHandle, IDC_SQLUSERNAME);
        SQLPassword_hWnd = GetDlgItem(xHandle, IDC_SQLPASSWORD);
        TempDir_hWnd     = GetDlgItem(xHandle, IDC_TEMPDIR);

        Set_Text(SQLServer_hWnd, gsSQLCustServer);
        Set_Text(SQLDriver_hWnd, gsSQLCustDriver);
        Set_Text(SQLUserName_hWnd, gsSQLCustUserID);
        Set_Text(SQLPassword_hWnd, gsSQLCustPassword);
        Set_Text(TempDir_hWnd, gsImportTempDir);

        return TRUE;
    }

	if(xMessage == WM_COMMAND)
    {
		if(wParam == IDC_PREPARE)
		{
			PrepareAllCustomerDBs();
			return FALSE;
		}
	}
	
	if(xMessage == WM_NOTIFY)
    {
        LPNMHDR pNMH = (LPNMHDR)lParam;

		if(pNMH->code == PSN_KILLACTIVE)
        {
            return FALSE;
        }
        if(pNMH->code == PSN_APPLY) // Ok
        {
            return TRUE;
        }
        if(pNMH->code == PSN_RESET) // Cancel
        {
            return FALSE;
        }
    }

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
